do
-- ambush check, only go live if SAM is behind a contacts 9-3 line.
function SkynetIADSSamSite:setGoLiveNineLine(enable)
	if not enable then
		self:removeGoLiveConstraint("9line")
	else
		self:addGoLiveConstraint("9line",
		function (contact)
		local contactHeading 	= mist.getHeading(contact:getDCSRepresentation())
		local contactHeadingSAM = mist.utils.getHeadingPoints(contact:getDCSRepresentation():getPosition().p, mist.getLeadPos(self:getDCSRepresentation()))
		local absDiff 			= math.abs(mist.utils.toDegree(contactHeading) - mist.utils.toDegree(contactHeadingSAM))
		
		if absDiff > 180 then 
			absDiff = 360 - absDiff
		end
		
		return absDiff > 100
		end)
	end
	
	return self
end


-- ambush check, only go live if buddy is live, buddy is preferably not mobile
function SkynetIADSSamSite:setGoLiveWithBuddy(buddySAM)
	self:addGoLiveConstraint("golivewithbuddy",
	function (contact)
		return buddySAM.aiState
	end)
	
	return self
end

end


--create an instance of the IADS
redIADS = SkynetIADS:create('Arab')

---debug settings remove from here on if you do not wan't any output on what the IADS is doing by default
local iadsDebug = redIADS:getDebugSettings()
iadsDebug.IADSStatus = true
iadsDebug.radarWentDark = true
iadsDebug.contacts = true
iadsDebug.radarWentLive = true
iadsDebug.noWorkingCommmandCenter = false
iadsDebug.ewRadarNoConnection = false
iadsDebug.samNoConnection = false
iadsDebug.jammerProbability = true
iadsDebug.addedEWRadar = false
iadsDebug.hasNoPower = false
iadsDebug.harmDefence = true
iadsDebug.samSiteStatusEnvOutput = true
iadsDebug.earlyWarningRadarStatusEnvOutput = true
iadsDebug.commandCenterStatusEnvOutput = true
---end remove debug ---

--add all units with unit name beginning with 'RedEW' to the IADS:
redIADS:addEarlyWarningRadarsByPrefix('RedEW')

--add all groups begining with group name 'RedSAM' to the IADS:
redIADS:addSAMSitesByPrefix('RedSAM')

-- all RedSAM will go Autonomus on EWR Destruction
redIADS:getSAMSitesByPrefix('RedSAM'):setAutonomousBehaviour(SkynetIADSAbstractRadarElement.AUTONOMOUS_STATE_DCS_AI)


-- hide, shoot, scoot tactics: SkynetIADSSamSite:setActMobile() enable true/false, maxEmissionTime in seconds, minScootDistance in meters, maxScootDistance in meters, table of pre-defined triggerZoneNames
-- redIADS:getSAMSitesByNatoName("SA-11"):setActMobile(true,60*5,5000,7500,nil) 	-- bit longer emission time, will stand its ground
redIADS:getSAMSitesByNatoName("SA-6"):setActMobile(true,60*2.25,500,8000)	-- short emission time = light on its feet

-- use different emission times to avoid having all SAMs relocate at the same time
-- redIADS:getSAMSiteByGroupName("RSAM BUK-B"):setActMobile(true,60*20,10000,15000) -- this BUK battery will not be as light on its feet, but will move greater distances, it is allowed to call setActMobile to change parameters

-- set pre-defined locations, this is not needed, if no pre-defined zones are supplied SAM will pick arbitrary direction
redIADS:getSAMSiteByGroupName("RedSAM KUB A"):setMobileScootZones({"KUB-A Zone-1","KUB-A Zone-2","KUB-A Zone-3","KUB-A Zone-4","KUB-A Zone-5","KUB-A Zone-6","KUB-A Zone-7","KUB-A Zone-8"})

redIADS:getSAMSiteByGroupName("RedSAM KUB B"):setMobileScootZones({"KUB-B Zone-1","KUB-B Zone-2","KUB-B Zone-3","KUB-B Zone-4","KUB-B Zone-5","KUB-B Zone-6"})

redIADS:getSAMSiteByGroupName("RedSAM KUB C"):setMobileScootZones({"KUB-C Zone-1","KUB-C Zone-2","KUB-C Zone-3","KUB-C Zone-4","KUB-C Zone-5","KUB-C Zone-6","KUB-C Zone-7","KUB-C Zone-8"})

--setup mobile point defences for one SA-11
-- redIADS:getSAMSiteByGroupName("RSAM BUK-A"):addPointDefence(redIADS:getSAMSiteByGroupName("RSAM BUK-A PD"):setActMobile(true))

-- this part has nothing to do with hide, shoot and scoot DEMO. it is purely for ambushing tactics
-- redIADS:getSAMSiteByGroupName("RedSAM KUB A"):setGoLiveWithBuddy(redIADS:getSAMSiteByGroupName("RedSAM-3"))
-- redIADS:getSAMSiteByGroupName("RedSAM KUB B"):setGoLiveWithBuddy(redIADS:getSAMSiteByGroupName("RedSAM-2"))
-- redIADS:getSAMSiteByGroupName("RedSAM KUB C"):setGoLiveWithBuddy(redIADS:getSAMSiteByGroupName("RedSAM-3"))
-- redIADS:getSAMSitesByNatoName("SA-6"):setGoLiveNineLine(true)

--add a command center:
local CommandCenter = StaticObject.getByName('Command Center RED')
local comPowerSource1 = StaticObject.getByName('Red CC PS Main')
local comPowerSource2 = StaticObject.getByName('Red CC PS BkUp')
local connectionNodeEWa = Unit.getByName('Red EW 1 Node')
local connectionNodeEWb = Unit.getByName('Red SAM 1-9 Node')
local connectionNodeEWc = Unit.getByName('Red SAM 2-9 Node')
local connectionNodeEWd = Unit.getByName('Red SAM 3-8 Node')
local connectionNodeEWe = Unit.getByName('Red SAM 4-5 Node')


if CommandCenter then
redIADS:addCommandCenter(CommandCenter):addPowerSource(comPowerSource1):addPowerSource(comPowerSource2):addConnectionNode(connectionNodeEWa):addConnectionNode(connectionNodeEWb):addConnectionNode(connectionNodeEWc):addConnectionNode(connectionNodeEWd):addConnectionNode(connectionNodeEWe)
end


--add power sources and a connection node for this EW radar:
local powerSourceA = StaticObject.getByName('Red EW 1 PS Main')
local connectionNodeEW = Unit.getByName('Red EW 1 Node')
redIADS:getEarlyWarningRadarByUnitName('RedEW 1'):addPowerSource(powerSourceA):addConnectionNode(connectionNodeEW)

local powerSourceB = StaticObject.getByName('Red EW 1 PS BkUp')
redIADS:getEarlyWarningRadarByUnitName('RedEW 1'):addPowerSource(powerSourceB)

local connectionNode = Unit.getByName('Red SAM 1-9 Node') 
local powerSource = StaticObject.getByName('Red SAM 1 PS Main')
redIADS:getSAMSiteByGroupName('RedSAM-1'):addConnectionNode(connectionNode):addPowerSource(powerSource)


local connectionNode = Unit.getByName('Red SAM 2-9 Node') 
local powerSource = StaticObject.getByName('Red SAM 2 PS Main')
redIADS:getSAMSiteByGroupName('RedSAM-2'):addConnectionNode(connectionNode):addPowerSource(powerSource)


local connectionNode = Unit.getByName('Red SAM 3-8 Node') 
local powerSource = StaticObject.getByName('Red SAM 3 PS Main')
redIADS:getSAMSiteByGroupName('RedSAM-3'):addConnectionNode(connectionNode):addPowerSource(powerSource)


local connectionNode = Unit.getByName('Red SAM 4-5 Node') 
local powerSource = StaticObject.getByName('Red SAM 4 PS Main')
redIADS:getSAMSiteByGroupName('RedSAM-4'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM-5-2-Node') 
local powerSource = StaticObject.getByName('Red SAM-5-PS')
redIADS:getSAMSiteByGroupName('RedSAM-5'):addConnectionNode(connectionNode):addPowerSource(powerSource)


local connectionNode = Unit.getByName('Red SAM SHORAD 1-1 Node')
local powerSource = Unit.getByName('Red SAM SHORAD 1 PS Main')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD 1'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM SHORAD AAA 2-1 Node')
local powerSource = StaticObject.getByName('Red SAM SHORAD 2 PS')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 2'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM SHORAD AAA 3-1 Node')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 3'):addConnectionNode(connectionNode)


local connectionNode = Unit.getByName('Red SAM SHORAD AAA 4-1 Node')
local powerSource = StaticObject.getByName('Red SAM SHORAD 4 PS')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 4'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM SHORAD AAA 5-1 Node')
local powerSource = StaticObject.getByName('Red SAM SHORAD 5 PS')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 5'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM SHORAD AAA 6-1 Node')
local powerSource = StaticObject.getByName('Red SAM SHORAD 6 PS')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 6'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM SHORAD AAA 7-1 Node')
local powerSource = StaticObject.getByName('Red SAM SHORAD 7 PS')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 7'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red SAM SHORAD AAA 8-2 Node')
local powerSource = StaticObject.getByName('Red-SAM-SHORAD-8-PS')
redIADS:getSAMSiteByGroupName('RedSAM SHORAD AAA 8'):addConnectionNode(connectionNode):addPowerSource(powerSource)


local connectionNode = Unit.getByName('Red-SAM-SHORAD-9-2-Node')
local powerSource = StaticObject.getByName('Red-SAM-SHORAD-9-PS')
redIADS:getSAMSiteByGroupName('RedSAM-SHORAD-AAA-9'):addConnectionNode(connectionNode):addPowerSource(powerSource)

local connectionNode = Unit.getByName('Red EW 1 Node')
local powerSource = Unit.getByName('Red-EW-1-AD-PS')
redIADS:getSAMSiteByGroupName('RedSAM-SHORAD-AAA-10'):addConnectionNode(connectionNode):addPowerSource(powerSource)


redIADS:getSAMSiteByGroupName('RedSAM KUB A'):setEngagementZone(SkynetIADSAbstractRadarElement.GO_LIVE_WHEN_IN_SEARCH_RANGE)

redIADS:getSAMSiteByGroupName('RedSAM KUB B'):setEngagementZone(SkynetIADSAbstractRadarElement.GO_LIVE_WHEN_IN_SEARCH_RANGE)

redIADS:getSAMSiteByGroupName('RedSAM KUB C'):setEngagementZone(SkynetIADSAbstractRadarElement.GO_LIVE_WHEN_IN_SEARCH_RANGE)



redIADS:addRadioMenu()

redIADS:activate()



 
------setup blue IADS:
blueIADS = SkynetIADS:create('Nato')

local iadsDebug = blueIADS:getDebugSettings()
iadsDebug.IADSStatus = true
iadsDebug.radarWentDark = true
iadsDebug.contacts = true
iadsDebug.radarWentLive = true
iadsDebug.noWorkingCommmandCenter = false
iadsDebug.samNoConnection = false
iadsDebug.jammerProbability = true
iadsDebug.addedEWRadar = false
iadsDebug.harmDefence = true
iadsDebug.warnings = false
iadsDebug.samSiteStatusEnvOutput = true
iadsDebug.earlyWarningRadarStatusEnvOutput = true
iadsDebug.commandCenterStatusEnvOutput = true



blueIADS:addSAMSitesByPrefix('BLueSAM')
blueIADS:addEarlyWarningRadarsByPrefix('BLueEW')

-- all BLueSAM will go Autonomus on EWR Destruction
blueIADS:getSAMSitesByPrefix('BLueSAM'):setAutonomousBehaviour(SkynetIADSAbstractRadarElement.AUTONOMOUS_STATE_DCS_AI)

--add a command center:
local CommandCenter = StaticObject.getByName('Command Center BLUE')
local comPowerSource1 = StaticObject.getByName('BLue CC PS Main')
local comPowerSource2 = StaticObject.getByName('BLue CC PS BkUp')
local connectionNodeEWa = StaticObject.getByName('BLue EW 1 Node')
local connectionNodeEWb = Unit.getByName('BLue SAM 1-4 Node')
local connectionNodeEWc = Unit.getByName('BLue SAM 2-4 Node')
local connectionNodeEWd = Unit.getByName('BLue SAM 3-9 Node')
local connectionNodeEWe = Unit.getByName('BLue SAM 4-10 Node')


if CommandCenter then
blueIADS:addCommandCenter(CommandCenter):addPowerSource(comPowerSource1):addPowerSource(comPowerSource2):addConnectionNode(connectionNodeEWa):addConnectionNode(connectionNodeEWb):addConnectionNode(connectionNodeEWc):addConnectionNode(connectionNodeEWd):addConnectionNode(connectionNodeEWe)
end


--add power sources and a connection node for this EW radar:
local connectionNodeEW = StaticObject.getByName('BLue EW 1 Node')
local powerSource1 = StaticObject.getByName("BLue EW 1 PS Main")
blueIADS:getEarlyWarningRadarByUnitName('BLueEW 1'):addPowerSource(powerSource1):addConnectionNode(connectionNodeEW)

local powerSource2 = StaticObject.getByName('BLue EW 1 PS BkUp')
blueIADS:getEarlyWarningRadarByUnitName("BLueEW 1"):addPowerSource(powerSource2)

local connectionNode = Unit.getByName('BLue SAM 1-4 Node')
local powerSource = StaticObject.getByName('BLue SAM 1 PS Main')
blueIADS:getSAMSiteByGroupName('BLueSAM 1'):addPowerSource(powerSource):addConnectionNode(connectionNode)

local connectionNode = Unit.getByName('BLue SAM 2-4 Node')
local powerSource = StaticObject.getByName('BLue SAM 2 PS Main')
blueIADS:getSAMSiteByGroupName('BLueSAM 2'):addConnectionNode(connectionNode):addPowerSource(powerSource)


local connectionNode = Unit.getByName('BLue SAM 3-9 Node')
local powerSource = StaticObject.getByName('BLue SAM 3 PS Main')
blueIADS:getSAMSiteByGroupName('BLueSAM 3'):addPowerSource(powerSource):addConnectionNode(connectionNode)


local connectionNode = Unit.getByName('BLue SAM 4-10 Node')
local powerSource = Unit.getByName('BLue SAM 4-1 PS Main')
blueIADS:getSAMSiteByGroupName('BLueSAM 4'):addPowerSource(powerSource):addConnectionNode(connectionNode)

local connectionNode = Unit.getByName('BLue SAM 5-3 Node')
local powerSource = StaticObject.getByName('BLue SAM 5 PS')
blueIADS:getSAMSiteByGroupName('BLueSAM-5'):addPowerSource(powerSource):addConnectionNode(connectionNode)


local connectionNode = Unit.getByName('BLue SAM 7-3 Node')
local powerSource = Unit.getByName('BLue SAM 7 PS Mobile')
blueIADS:getSAMSiteByGroupName('BLueSAM 7'):addPowerSource(powerSource):addConnectionNode(connectionNode)

local connectionNode = Unit.getByName('BLue SAM 8-3 Node')
local powerSource = StaticObject.getByName('BLue-SAM-8-PS')
blueIADS:getSAMSiteByGroupName('BLueSAM 8'):addPowerSource(powerSource):addConnectionNode(connectionNode)





blueIADS:addRadioMenu()

blueIADS:activate()
